/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Point;
import jclass.chart.ActionHandler;
import jclass.chart.JCChartArea;
import jclass.chart.JCChartUtil;

class RotateHandler
extends ActionHandler {
    boolean doRotation = false;
    public static final int MAX_ELEVATION = 45;
    public static final int MAX_ROTATION = 45;
    Point first;
    Point last;
    int orig_elevation;
    int orig_rotation;
    boolean pieChart = false;

    RotateHandler(JCChartArea jCChartArea) {
        super(jCChartArea);
    }

    void start(int n, int n2) {
        this.parent.inAction = true;
        this.first = new Point(n, n2);
        this.last = null;
        this.doRotation = this.parent.getDepth() != 0 && this.parent.chart.getDataView(0).getChartType() != 0;
        this.orig_elevation = this.parent.getElevation();
        this.orig_rotation = this.parent.getRotation();
        this.pieChart = this.parent.chart.getDataView(0).getChartType() == 11;
    }

    void animate(int n, int n2) {
        if (!this.doRotation) {
            return;
        }
        if (this.first == null) {
            return;
        }
        if (this.last == null) {
            this.last = new Point(n, n2);
            return;
        }
        if (n2 == this.last.y && n == this.last.x) {
            return;
        }
        int n3 = n2 - this.first.y;
        int n4 = n - this.first.x;
        double d = 90.0 / (double)this.parent.plotRect.width;
        double d2 = 90.0 / (double)this.parent.plotRect.height;
        int n5 = this.orig_elevation;
        int n6 = this.orig_rotation;
        if (this.pieChart) {
            n5 = (int)((double)n5 - (double)n3 * d2);
        } else {
            n6 = (int)((double)n6 - (double)n4 * d);
            n5 = (int)((double)n5 + (double)n3 * d2);
        }
        n5 = (int)JCChartUtil.clamp((double)n5, -45.0, 45.0);
        n6 = (int)JCChartUtil.clamp((double)n6, -45.0, 45.0);
        this.last.x = n;
        this.last.y = n2;
        if (n5 != this.parent.getElevation() || n6 != this.parent.getRotation()) {
            boolean bl = false;
            if (this.parent.chart != null) {
                bl = this.parent.chart.getIsBatched();
                this.parent.chart.setIsBatched(true);
            }
            this.parent.setElevation(n5);
            this.parent.setRotation(n6);
            if (this.parent.chart != null) {
                this.parent.chart.setIsBatched(bl);
            }
        }
    }

    void reanimate(int n, int n2) {
    }

    void end(int n, int n2) {
        this.parent.inAction = false;
        if (this.parent.fastAction) {
            this.parent.setChanged(true);
        }
    }
}

